'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database
Option Explicit

Private Sub Berichtsfu_Format(Cancel As Integer, FormatCount As Integer)
    Const conPI = 3.14159265359
    
    Dim KastenOben As Long          'Position der Diagrammgrenzen auf der Zeichenflche
    Dim KastenUnten As Long
    Dim KastenLinks As Long
    Dim KastenRechts As Long
    
    Dim ZeVe As Long                'Kreiseigenschaften
    Dim ZeHo As Long
    Dim Radius As Long
    Dim sBegin As Single            'Kreissegment
    Dim sEnde As Single
        
    Dim FilterText As String
    Dim DataMax As Double
    Dim FarbNummer As Integer       'Farben der Kreissegmente
    Dim ZeilenNummer As Long        'Nummerierung der Kreissegmente
    Dim PosLinksRechts As Long      'Positionen der Kreisbeschriftungen
    Dim PosObenUnten As Long
    
    
    'Erst beginnen, wenn der Jahresfilter gesetzt wurde!
    If Me.Filter = "" Then Exit Sub
        

    KastenOben = 1000               'Absolute Positionen auf dem Papier
    KastenUnten = 5000              'H, B jeweils 4000
    KastenLinks = 2500
    KastenRechts = 6500
    
    ZeVe = KastenOben + Fix((KastenUnten - KastenOben) / 2)             'Kreismittelpunkt vertikal
    ZeHo = KastenLinks + Fix((KastenRechts - KastenLinks) / 2)          'Kreismittelpunkt horizontal
    Radius = KastenRechts - ZeHo

    
    FilterText = "SELECT * FROM " & Me.RecordSource & " WHERE " & Me.Filter & " ORDER BY " & Me.OrderBy
    Set dbs = CurrentDb                             'Datenstze holen
    Set rst = dbs.OpenRecordset(FilterText)
    
    If rst.RecordCount = 0 Then
        rst.Close
        Set dbs = Nothing
        Exit Sub
    End If
    
    Me.Circle (ZeHo, ZeVe), Radius              'Hauptkreis
    
    rst.MoveLast                                'Recordsetobjekt auffllen
    
    DataMax = 0                                 'Maximalwert aller positiven Gewinne ermitteln
    rst.MoveFirst
    Do While Not rst.EOF
        If rst!SummeVonKalkulation > 0 Then DataMax = DataMax + rst!SummeVonKalkulation
        rst.MoveNext
    Loop

    rst.MoveFirst                               'zum ersten Datensatz
    sBegin = -0.000000000001
    FarbNummer = 1
    ZeilenNummer = 1
    Do While Not rst.EOF
        If rst!SummeVonKalkulation > 0 Then
            sEnde = sBegin + (-2 * conPI * (rst!SummeVonKalkulation / DataMax))
            Select Case FarbNummer
                Case 1
                    Me.FillColor = RGB(RGB_Rot1, RGB_Gruen1, RGB_Blau1)
                Case 2
                    Me.FillColor = RGB(RGB_Rot2, RGB_Gruen2, RGB_Blau2)
                Case 3
                    Me.FillColor = RGB(RGB_Rot3, RGB_Gruen3, RGB_Blau3)
                Case 4
                    Me.FillColor = RGB(RGB_Rot4, RGB_Gruen4, RGB_Blau4)
                Case 5
                    Me.FillColor = RGB(RGB_Rot5, RGB_Gruen5, RGB_Blau5)
                Case 6
                    Me.FillColor = RGB(RGB_Rot6, RGB_Gruen6, RGB_Blau6)
                Case 7
                    Me.FillColor = RGB(RGB_Rot7, RGB_Gruen7, RGB_Blau7)
                Case 8
                    Me.FillColor = RGB(RGB_Rot8, RGB_Gruen8, RGB_Blau8)
            End Select
            Me.FillStyle = 0                        'Fllung undurchsichtig
            Me.Circle (ZeHo, ZeVe), Radius, , sBegin, sEnde
            
            FarbNummer = FarbNummer + 1
            If FarbNummer > 8 Then FarbNummer = 1
            
            'Schriftart einstellen
            If SchriftArtWahl = "Arial" Then Me.FontName = "Arial"
            If SchriftArtWahl = "Times" Then Me.FontName = "Times New Roman"
            'Position fr Beschriftung auf dem Kreisbogen... plus Abstand zum Kreis (Textbreite/-hhe bercksichtigen!)
            PosObenUnten = ZeHo - (Cos(sEnde - ((sEnde - sBegin) / 2)) * (-1)) * (Radius + (Radius * 0.1) + ((Me.TextWidth(Str(ZeilenNummer)) / 2) * (Cos(sEnde - ((sEnde - sBegin) / 2)) * (-1))))
            PosLinksRechts = ZeVe - (Sin(sEnde - ((sEnde - sBegin) / 2)) * (-1)) * (Radius + (Radius * 0.1) + ((Me.TextHeight(Str(ZeilenNummer)) / 2) * (Sin(sEnde - ((sEnde - sBegin) / 2)) * (-1))))
            'Schreibposition festlegen
            '.CurrentX und .CurrentY sind in diesem Fall zu ungenau!
            Me.Line (PosObenUnten, PosLinksRechts)-(PosObenUnten, PosLinksRechts)
            'Beschriftung ausgeben
            Me.Print ZeilenNummer
    
    
            ZeilenNummer = ZeilenNummer + 1
            
            
            sBegin = sEnde
            
            'der Rest unter X Prozent als Schraffur
            If (sBegin < (-2 * conPI * ((100 - KreisrestProzent) / 100))) And (sBegin > (-2 * conPI)) Then
                Me.FillColor = RGB(0, 0, 0)
                Me.FillStyle = 7                        'Fllung diagonale Kreuzschraffur
                Me.Circle (ZeHo, ZeVe), Radius, , sBegin, (-2 * conPI)
                Exit Do
            End If
        End If
        
        rst.MoveNext
    Loop
    
    rst.Close
    Set dbs = Nothing

End Sub

Private Sub Detailbereich_Format(Cancel As Integer, FormatCount As Integer)
    Dim von, bis As Long                    'Absolute Positionen auf dem Bericht
    Dim Laenge As Double                    '"Spannweite" vom grssten zum kleinsten Wert (in Minuten),
                                            '   um den Nullpunkt zu ermitteln
    Dim MinDauer, MaxDauer As Double
    Dim Start, Ende, Nullpunkt As Long      'Start und Ende der zu zeichnenden Linie
    
    Dim FilterText As String
    
    von = 6500                             'je nach gewnschter Position auf dem Bericht anzupassen
    bis = 9050
    
    
    'Bestimmung von Laenge und Nullpunkt
    MinDauer = Me.DauerMin
    MaxDauer = Me.DauerMax
    If MaxDauer <= 0 Then MaxDauer = 0.0001
    If MinDauer >= 0 Then MinDauer = 0.0001
    If MinDauer < 0 Then MinDauer = MinDauer * (-1)
    Laenge = MinDauer + MaxDauer
    Nullpunkt = von + Int((MinDauer / Laenge) * (bis - von))
    
    'Bestimmung von Start und Ende
    If Me.SummeVonKalkulation < 0 Then
        Start = Nullpunkt - Int(((Me.SummeVonKalkulation * (-1)) / MinDauer) * (Nullpunkt - von))
        Ende = Nullpunkt
    Else
        Start = Nullpunkt
        Ende = Nullpunkt + Int((Me.SummeVonKalkulation / MaxDauer) * (bis - Nullpunkt))
    End If
    
    
    'bei negativen Werten: rote Linie
    If Me.SummeVonKalkulation < 0 Then
        Me.ForeColor = RGB(RGB_MinusRot, RGB_MinusGruen, RGB_MinusBlau)         'Negativ
    Else
        Me.ForeColor = RGB(RGB_PlusRot, RGB_PlusGruen, RGB_PlusBlau)            'Positiv
    End If

    Me.Line (Start, 50)-(Ende, 150), , BF       'Balken im Bericht zeichnen
    
    'zum Schluss(!) die Nullkoordinate zur Orientierung zeichnen
    Me.ForeColor = RGB(0, 0, 0)                 'Schwarz
    Me.Line (Nullpunkt, 0)-(Nullpunkt, 250)
        
End Sub

Private Sub Report_Activate()
    On Error Resume Next
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
End Sub

Private Sub Report_Open(Cancel As Integer)
    SchriftartFuerBerichtEinstellen Me
    Me.ImpFusszeile.Caption = ImpressumBerichtsfuss
    
    'aktuelles Whrungsformat des Systems einstellen
    Me.BerechnetNetto.Format = "Currency"
    Me.Text70.Format = "Currency"               'Summenzeile

    Me.Filter = BerichteFilter
    Me.Ueberschrift.Caption = BerichteUeberschrift
    'Me.Jahresfilter.Caption = BerichteJahreswahl
    Me.FilterOn = True
End Sub
